/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool;

import dev.figboot.autool.config.PatchProperties;
import dev.figboot.autool.patcher.ProgramPatcher;
import dev.figboot.autool.ui.CLIProgressUpdater;
import dev.figboot.autool.ui.ProgressUpdater;
import dev.figboot.autool.ui.SwingProgressUpdater;
import dev.figboot.autool.util.OperatingSystem;
import dev.figboot.autool.util.exception.CancelledException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class AutoOL {
    public static void main(String[] args) throws Exception {
        Method mainMethod = AutoOL.realMain(args);
        System.gc();
        mainMethod.invoke(null, new Object[]{args});
    }

    static Method realMain(String[] args) {
        PatchProperties settings;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> workDirArg = parser.accepts("workDir").withRequiredArg().ofType(File.class).defaultsTo(AutoOL.getWorkingDirectory(), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> proxyHostArg = parser.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec<Integer> proxyPortArg = parser.accepts("proxyPort").withRequiredArg().ofType(Integer.class).defaultsTo(8080, (Integer[])new Integer[0]);
        OptionSet opts = parser.parse(args);
        try {
            settings = new PatchProperties();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Proxy proxy = Proxy.NO_PROXY;
        String host = opts.valueOf(proxyHostArg);
        if (opts.valueOf(proxyHostArg) != null) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, (int)opts.valueOf(proxyPortArg)));
        }
        File workDir = opts.valueOf(workDirArg);
        System.out.println("Using working directory: " + workDir.getAbsolutePath());
        System.out.println("Interactive: " + (settings.isInteractive() ? "yes" : "no"));
        ProgressUpdater progress = settings.isInteractive() ? new SwingProgressUpdater() : new CLIProgressUpdater();
        ProgramPatcher patcher = new ProgramPatcher(settings, proxy, workDir, progress);
        Method method = null;
        try {
            patcher.init();
            method = patcher.getMainMethod();
        }
        catch (CancelledException ex) {
            System.out.println("Operation cancelled, exiting...");
            try {
                progress.shutdown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("Error in patcher, exiting...:");
            ex.printStackTrace();
            try {
                progress.shutdown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
        try {
            progress.shutdown();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        System.getProperties().putAll(settings.getSystemProperties());
        return method;
    }

    private static File getWorkingDirectory() {
        String homeDir = System.getProperty("user.home", ".");
        switch (OperatingSystem.getOS()) {
            case WINDOWS: {
                String appData = System.getenv("AppData");
                return new File(appData == null ? homeDir : appData, ".minecraft");
            }
            case OSX: {
                return new File(homeDir, "Library/Application Support/minecraft");
            }
            case LINUX: {
                return new File(homeDir, ".minecraft");
            }
        }
        return new File(homeDir, "minecraft");
    }
}

