/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool.ui;

import dev.figboot.autool.ui.ProgressUpdater;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class SwingProgressUpdater
extends JFrame
implements ProgressUpdater {
    private JLabel statusLabel;
    private JProgressBar progressBar;
    private boolean cancelOp;

    public SwingProgressUpdater() {
        this.initInterface();
        this.cancelOp = false;
    }

    private void initInterface() {
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        this.setTitle("OLauncher Redistributable");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        Box mainBox = Box.createVerticalBox();
        mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        mainPanel.add(mainBox);
        this.statusLabel = new JLabel("Please wait...");
        Box lblBox = Box.createHorizontalBox();
        lblBox.add(this.statusLabel);
        lblBox.add(Box.createHorizontalGlue());
        mainBox.add(lblBox);
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setPreferredSize(new Dimension(300, this.progressBar.getMinimumSize().height));
        mainBox.add(this.progressBar);
        mainBox.add(Box.createVerticalStrut(5));
        Box boxCancelButton = Box.createHorizontalBox();
        JButton cancelButton = new JButton("Cancel");
        boxCancelButton.add(Box.createHorizontalGlue());
        boxCancelButton.add(cancelButton);
        mainBox.add(boxCancelButton);
        cancelButton.addActionListener(evt -> {
            this.cancelOp = true;
            cancelButton.setEnabled(false);
        });
        this.pack();
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingProgressUpdater.this.cancelOp = true;
            }
        });
    }

    @Override
    public void changeStatus(String status) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(status);
            this.progressBar.setValue(0);
        });
    }

    @Override
    public void setMaxProgress(int max) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setMaximum(max);
            this.updateProgressBarText();
        });
    }

    @Override
    public void setProgress(int progress) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setValue(progress);
            this.updateProgressBarText();
        });
    }

    private void updateProgressBarText() {
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(String.format("%d%%", this.progressBar.getValue() * 100 / this.progressBar.getMaximum()));
    }

    @Override
    public boolean cancelOperation() {
        return this.cancelOp;
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void error(Object message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }
}

