/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool.util;

import java.util.Locale;
import lombok.Generated;

public enum OperatingSystem {
    WINDOWS("win"),
    LINUX("linux", "unix"),
    OSX("osx", "mac"),
    SOLARIS("sunos"),
    UNKNOWN(new String[0]);

    private final String[] searchStr;
    private static OperatingSystem OS;

    private OperatingSystem(String ... search) {
        this.searchStr = search;
    }

    private static void initOS() {
        if (OS != null) {
            throw new IllegalStateException("OS already initialized");
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        for (OperatingSystem val : OperatingSystem.values()) {
            for (String search : val.searchStr) {
                if (!osName.contains(search)) continue;
                OS = val;
                return;
            }
        }
        OS = UNKNOWN;
    }

    @Generated
    public static OperatingSystem getOS() {
        return OS;
    }

    static {
        OperatingSystem.initOS();
    }
}

