/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.ca;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ca extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Hora d'\u00c0frica Central",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Hora est\u00e0ndard de Moscou",
               "MST",
               "Hora d'estiu de Moscou",
               "MST",
               "Hora de Moscou",
               "MT",
            };
        final String[] Japan = new String[] {
               "Hora est\u00e0ndard del Jap\u00f3",
               "JST",
               "Hora d'estiu del Jap\u00f3",
               "JDT",
               "Hora del Jap\u00f3",
               "JT",
            };
        final String[] Argentina = new String[] {
               "Hora est\u00e0ndard de l'Argentina",
               "AST",
               "Horari d'estiu de l'Argentina",
               "AST",
               "Hora de l'Argentina",
               "AT",
            };
        final String[] Hovd = new String[] {
               "Hora est\u00e0ndard de Hovd",
               "HST",
               "Horari d'estiu de Hovd",
               "HST",
               "Hora de Hovd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Hora est\u00e0ndard de Magadan",
               "MST",
               "Horari d'estiu de Magadan",
               "MST",
               "Hora de Magadan",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora est\u00e0ndard d'Austr\u00e0lia centre-occidental",
               "ACWST",
               "Hora d'estiu d'Austr\u00e0lia centre-occidental",
               "ACWDT",
               "Hora d'Austr\u00e0lia centre-occidental",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Hora est\u00e0ndard Central Europea",
               "CEST",
               "Hora Central Europea de l'estiu",
               "CEST",
               "Hora Central Europea",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Hora est\u00e0ndard de Sakhalin",
               "SST",
               "Horari d'estiu de Sakhalin",
               "SST",
               "Hora de Sakhalin",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Hora de Macquarie",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "Hora est\u00e0ndard oriental",
               "EST",
               "Hora d'estiu oriental",
               "EDT",
               "Hora oriental",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora est\u00e0ndard de Hawaii Aleutian",
               "HAST",
               "Hora d'estiu de Hawaii Aleutian",
               "HADT",
               "Hora de Hawaii Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Hora est\u00e0ndard d'Austr\u00e0lia Central",
               "ACST",
               "Hora d'estiu d'Austr\u00e0lia Central",
               "ACDT",
               "Hora d'Austr\u00e0lia Central",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "Hora est\u00e0ndard de Lord Howe",
               "LHST",
               "Horari d'estiu de Lord Howe",
               "LHDT",
               "Hora de Lord Howe",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "Hora est\u00e0ndard de Iakutsk",
               "YST",
               "Horari d'estiu de Iakutsk",
               "YST",
               "Hora de Iakutsk",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "Hora est\u00e0ndard del Pac\u00edfic",
               "PST",
               "Hora d'estiu del Pac\u00edfic",
               "PDT",
               "Hora del Pac\u00edfic",
               "PT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora d'\u00c0frica Oriental",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Western = new String[] {
               "Hora est\u00e0ndard d'Europa Occidental",
               "WEST",
               "Hora d'estiu d'Europa Occidental",
               "WEST",
               "Hora d'Europa Occidental",
               "WET",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora est\u00e0ndard d'Europa de l'Est",
               "EEST",
               "Hora d'estiu d'Europa de l'Est",
               "EEST",
               "Hora d'Europa de l'Est",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Hora est\u00e0ndard de Terranova",
               "NST",
               "Horari d'estiu de Terranova",
               "NDT",
               "Hora de Terranova",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "Hora est\u00e0ndard de l'oest de l'Argentina",
               "WAST",
               "Horari d'estiu de l'oest de l'Argentina",
               "WAST",
               "Hora de l'oest de l'Argentina",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Hora est\u00e0ndard de l'Atl\u00e0ntic",
               "AST",
               "Hora d'estiu de l'Atl\u00e0ntic",
               "ADT",
               "Hora de l'Atl\u00e0ntic",
               "AT",
            };
        final String[] Africa_Western = new String[] {
               "Hora est\u00e0ndard d'\u00c0frica Occidental",
               "WAST",
               "Hora d'estiu d'\u00c0frica Occidental",
               "WAST",
               "Hora d'\u00c0frica Occidental",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Hora mitjana de Greenwich",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora est\u00e0ndard d'Ekaterinburg",
               "YST",
               "Horari d'estiu d'Ekaterinburg",
               "YST",
               "Hora d'Ekaterinburg",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "Hora est\u00e0ndard de Volgograd",
               "VST",
               "Hora d'estiu de Volgograd",
               "VST",
               "Hora de Volgograd",
               "VT",
            };
        final String[] Israel = new String[] {
               "Hora est\u00e0ndard d'Israel",
               "IST",
               "Hora d'estiu d'Israel",
               "IDT",
               "Hora d'Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Hora central d'Indon\u00e8sia",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora d'\u00c0frica Austral",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Hora de l'est d'Indon\u00e8sia",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Hora est\u00e0ndard de Corea",
               "KST",
               "Hora d'estiu de Corea",
               "KDT",
               "Hora de Corea",
               "KT",
            };
        final String[] Omsk = new String[] {
               "Hora est\u00e0ndard d'Omsk",
               "OST",
               "Horari d'estiu d'Omsk",
               "OST",
               "Hora d'Omsk",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "Hora est\u00e0ndard d'Austr\u00e0lia Occidental",
               "AWST",
               "Hora d'estiu d'Austr\u00e0lia Occidental",
               "AWDT",
               "Hora d'Austr\u00e0lia Occidental",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Hora de l'oest d'Indon\u00e8sia",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "Hora est\u00e0ndard d'Ulan Bator",
               "UBST",
               "Horari d'estiu d'Ulan Bator",
               "UBST",
               "Hora d'Ulan Bator",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Hora est\u00e0ndard central",
               "CST",
               "Hora d'estiu central",
               "CDT",
               "Hora central",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora est\u00e0ndard d'Austr\u00e0lia Oriental",
               "AEST",
               "Hora d'estiu d'Austr\u00e0lia Oriental",
               "AEDT",
               "Hora d'Austr\u00e0lia Oriental",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "Hora est\u00e0ndard de muntanya",
               "MST",
               "Hora d'estiu de muntanya",
               "MDT",
               "Hora de muntanya",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Hora est\u00e0ndard d'Ar\u00e0bia",
               "AST",
               "Hora d'estiu d'Ar\u00e0bia",
               "ADT",
               "Hora d'Ar\u00e0bia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Horari est\u00e0ndard d'Alaska",
               "AKST",
               "Horari d'estiu d'Alaska",
               "AKDT",
               "Hora d'Alaska",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora est\u00e0ndard de Novosibirsk",
               "NST",
               "Horari d'estiu de Novosibirsk",
               "NST",
               "Hora de Novosibirsk",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "Hora est\u00e0ndard de Vladivostok",
               "VST",
               "Horari d'estiu de Vladivostok",
               "VST",
               "Hora de Vladivostok",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Hora est\u00e0ndard d'Irkutsk",
               "IST",
               "Horari d'estiu d'Irkutsk",
               "IST",
               "Hora d'Irkutsk",
               "IT",
            };
        final String[] Noronha = new String[] {
               "Hora est\u00e0ndard de Fernando de Noronha",
               "FNST",
               "Horari d'estiu de Fernando de Noronha",
               "FNST",
               "Hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Hora est\u00e0ndard de Choibalsan",
               "CST",
               "Horari d'estiu de Choibalsan",
               "CST",
               "Hora de Choibalsan",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Hora de Bras\u00edlia",
               "BST",
               "Horari d'estiu de Bras\u00edlia",
               "BST",
               "Hora de Bras\u00edlia",
               "BT",
            };
        final String[] China = new String[] {
               "Hora est\u00e0ndard de la Xina",
               "CST",
               "Hora d'estiu de la Xina",
               "CDT",
               "Hora de la Xina",
               "CT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora est\u00e0ndard de Krasnoiarsk",
               "KST",
               "Horari d'estiu de Krasnoiarsk",
               "KST",
               "Hora de Krasnoiarsk",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora de l'oest del Kazakhstan",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] India = new String[] {
               "Hora est\u00e0ndard de l'\u00cdndia",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Amazon = new String[] {
               "Hora est\u00e0ndard de l'Amazones",
               "AST",
               "Hora d'estiu de l'Amazones",
               "AST",
               "Hora de l'Amazones",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora de l'est del Kazakhstan",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Libreville", Africa_Western },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Atlantic/St_Helena", GMT },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Europe/Guernsey", GMT },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Riyadh", Arabian },
            { "Africa/Windhoek", Africa_Western },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "America/Manaus", Amazon },
            { "Africa/Lome", GMT },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "Africa/Bamako", GMT },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Colombo", India },
            { "Asia/Omsk", Omsk },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Yakutsk", Yakutsk },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Africa/Niamey", Africa_Western },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "Asia/Pyongyang", Korea },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Yakutat", Alaska },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "Africa/Monrovia", GMT },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Africa/Accra", GMT },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
