/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.hr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "sredi\u0161nja Afrika vrijeme",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "moskovsko standardno vrijeme",
               "MST",
               "moskovsko ljetno vrijeme",
               "MST",
               "moskovsko vrijeme",
               "MT",
            };
        final String[] Japan = new String[] {
               "japansko standardno vrijeme",
               "JST",
               "japansko ljetno vrijeme",
               "JDT",
               "japansko vrijeme",
               "JT",
            };
        final String[] Hovd = new String[] {
               "Hovdsko standardno vrijeme",
               "HST",
               "Hovdsko ljetno vrijeme",
               "HST",
               "Hovdsko vrijeme",
               "HT",
            };
        final String[] Magadan = new String[] {
               "magadanska standardno vrijeme",
               "MST",
               "magadansko ljetno vrijeme",
               "MST",
               "magadanska vrijeme",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "australsko sredi\u0161nje zapadno standardno vrijeme",
               "ACWST",
               "australsko sredi\u0161nje zapadno ljetno vrijeme",
               "ACWDT",
               "australsko sredi\u0161nje zapadno vrijeme",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "srednjoeuropsko standardno vrijeme",
               "CET",
               "srednjoeuropsko ljetno vrijeme",
               "CEST",
               "srednjoeuropsko vrijeme",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinsko standardno vrijeme",
               "SST",
               "Sahalinsko ljetno vrijeme",
               "SST",
               "Sahalinsko vrijeme",
               "ST",
            };
        final String[] America_Eastern = new String[] {
               "isto\u010dno standardno vrijeme",
               "EST",
               "isto\u010dno ljetno vrijeme",
               "EDT",
               "isto\u010dno vrijeme",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "standardno vrijeme otoka Lord Howe",
               "LHST",
               "ljetno vrijeme otoka Lord Howe",
               "LHDT",
               "vrijeme otoka Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "standardno vrijeme Novog Zelanda",
               "NZST",
               "ljetno vrijeme Novog Zelanda",
               "NZDT",
               "vrijeme Novog Zelanda",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "vrijeme Indijskog oceana",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "jakutsko standardno vrijeme",
               "YST",
               "jakutsko ljetno vrijeme",
               "YST",
               "jakutsko vrijeme",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "standardno vrijeme Mauricijusa",
               "MST",
               "ljetno vrijeme Mauricijusa",
               "MST",
               "vrijeme Mauricijusa",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "isto\u010dna Afrika vrijeme",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Solomon = new String[] {
               "vrijeme Solomonovih otoka",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "vrijeme Kosrae",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "vrijeme Mar\u0161alovih Otoka",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "isto\u010dnoeuropsko standardno vrijeme",
               "EET",
               "isto\u010dnoeuropsko ljetno vrijeme",
               "EEST",
               "isto\u010dnoeuropsko vrijeme",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsko standardno vrijeme",
               "NST",
               "newfoundlandsko ljetno vrijeme",
               "NDT",
               "newfoundlandsko vrijeme",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "zapadno-argentinsko standardno vrijeme",
               "WAST",
               "zapadno-argentinsko ljetno vrijeme",
               "WAST",
               "zapadno-argentinsko vrijeme",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "atlantsko standardno vrijeme",
               "AST",
               "atlantsko dnevno vrijeme",
               "ADT",
               "atlantsko vrijeme",
               "AT",
            };
        final String[] Ponape = new String[] {
               "vrijeme Ponapea",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Indochina = new String[] {
               "indokinesko vrijeme",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "ekaterinbur\u0161ko standardno vrijeme",
               "YST",
               "ekaterinbur\u0161ko ljetno vrijeme",
               "YST",
               "ekaterinbur\u0161ko vrijeme",
               "YT",
            };
        final String[] Maldives = new String[] {
               "vrijeme Maldiva",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "vrijeme Tahitija",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "izraelsko standardno vrijeme",
               "IST",
               "izraelsko ljetno vrijeme",
               "IDT",
               "izraelsko vrijeme",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "srednjoindonezijsko vrijeme",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "vrijeme Otoka Wallis i Futuna",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017ena Afrika vrijeme",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "vrijeme Syowa",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "vrijeme Otoka Line",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Omsk = new String[] {
               "Omsko standardno vrijeme",
               "OST",
               "Omsko ljetno vrijeme",
               "OST",
               "Omsko vrijeme",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "sej\u0161elsko vrijeme",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Mongolia = new String[] {
               "ulan-batorsko standardno vrijeme",
               "UBST",
               "ulan-batorsko ljetno vrijeme",
               "UBST",
               "ulan-batorsko vrijeme",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "sredi\u0161nje standardno vrijeme",
               "CST",
               "sredi\u0161nje ljetno vrijeme",
               "CDT",
               "sredi\u0161nje vrijeme",
               "CT",
            };
        final String[] Truk = new String[] {
               "vrijeme Truka",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "vrijeme Niuea",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "vrijeme Otoka Wake",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "falklandsko standardno vrijeme",
               "FIST",
               "falklandsko ljetno vrijeme",
               "FIST",
               "falklandsko vrijeme",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "standardno vrijeme Vanuatu",
               "VST",
               "ljetno vrijeme Vanuatu",
               "VST",
               "vrijeme Vanuatu",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsko standardno vrijeme",
               "NST",
               "novosibirsko ljetno vrijeme",
               "NST",
               "novosibirsko vrijeme",
               "NT",
            };
        final String[] Azores = new String[] {
               "azorsko standardno vrijeme",
               "AST",
               "azorsko ljetno vrijeme",
               "AST",
               "azorsko vrijeme",
               "AT",
            };
        final String[] Nauru = new String[] {
               "vrijeme Naurua",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsko standardno vrijeme",
               "KST",
               "krasnojarsko ljetno vrijeme",
               "KST",
               "krasnojarsko vrijeme",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zapadno-kazahstansko vrijeme",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Christmas = new String[] {
               "vrijeme Bo\u017ei\u0107nog Otoka",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isto\u010dno-kazahstansko vrijeme",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "standardno vrijeme Fid\u017eija",
               "FST",
               "ljetno vrijeme Fid\u017eija",
               "FST",
               "vrijeme Fid\u017eija",
               "FT",
            };
        final String[] Reunion = new String[] {
               "vrijeme Reuniona",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "vrijeme Kokosovih Otoka",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "standardno vrijeme Chathama",
               "CST",
               "ljetno vrijeme Chathama",
               "CDT",
               "vrijeme Chathama",
               "CT",
            };
        final String[] Vostok = new String[] {
               "vrijeme Vostok",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "argentinsko standardno vrijeme",
               "AST",
               "argentinsko ljetno vrijeme",
               "AST",
               "argentinsko vrijeme",
               "AT",
            };
        final String[] Gambier = new String[] {
               "vrijeme Gambiera",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "vrijeme Tuvalu",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "vrijeme Galapagosa",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "vrijeme prema gradu Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsko standardno vrijeme",
               "HAST",
               "havajsko-aleutsko ljetno vrijeme",
               "HADT",
               "havajsko-aleutsko vrijeme",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "sredi\u0161nje australsko standardno vrijeme",
               "ACST",
               "sredi\u0161nje australsko ljetno vrijeme",
               "ACDT",
               "sredi\u0161nje australsko vrijeme",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "pacifi\u010dko standardno vrijeme",
               "PST",
               "pacifi\u010dko ljetno vrijeme",
               "PDT",
               "pacifi\u010dko vrijeme",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "vrijeme Otoka Phoenix",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Europe_Western = new String[] {
               "zapadnoeuropsko standardno vrijeme",
               "WET",
               "zapadnoeuropsko ljetno vrijeme",
               "WEST",
               "zapadnoeuropsko vrijeme",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "standardno vrijeme Zelenortskog oto\u010dja",
               "CVST",
               "ljetno vrijeme Zelenortskog oto\u010dja",
               "CVST",
               "vrijeme Zelenortskog oto\u010dja",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "vrijeme Otoka Norfolk",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Pitcairn = new String[] {
               "vrijeme Pitcairna",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "vrijeme Rothera",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Samoa = new String[] {
               "samoansko vrijeme",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "vrijeme Palaua",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Mawson = new String[] {
               "vrijeme Mawson",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "vrijeme Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Africa_Western = new String[] {
               "Zapadna Afrika standardno vrijeme",
               "WAST",
               "Zapadna Afrika ljetno vrijeme",
               "WAST",
               "Zapadna Afrika vrijeme",
               "WAT",
            };
        final String[] GMT = new String[] {
               "univerzalno vrijeme",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] French_Southern = new String[] {
               "ju\u017eno francusko i antarkti\u010dko vrijeme",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "vrijeme Ju\u017ene D\u017eord\u017eije",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "standardno vrijeme Nove Kaledonije",
               "NCST",
               "ljetno vrijeme Nove Kaledonije",
               "NCST",
               "vrijeme Nove Kaledonije",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "volgogradsko standardno vrijeme",
               "VST",
               "volgogradsko ljetno vrijeme",
               "VST",
               "volgogradsko vrijeme",
               "VT",
            };
        final String[] Easter = new String[] {
               "standardno vrijeme Uskr\u0161njih Otoka",
               "EIST",
               "ljetno vrijeme Uskr\u0161njih Otoka",
               "EIST",
               "vrijeme Uskr\u0161njih Otoka",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "vrijeme Dumont-d'Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tonga = new String[] {
               "standardno vrijeme Tonga",
               "TST",
               "ljetno vrijeme Tonga",
               "TST",
               "vrijeme Tonga",
               "TT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "isto\u010dnoindonezijsko vrijeme",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "korejsko standardno vrijeme",
               "KST",
               "korejsko ljetno vrijeme",
               "KDT",
               "korejsko vrijeme",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "zapadno australsko standardno vrijeme",
               "AWST",
               "zapadno australsko ljetno vrijeme",
               "AWDT",
               "zapadno australsko vrijeme",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "zapadnoindonezijsko vrijeme",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "isto\u010dno australsko standardno vrijeme",
               "AEST",
               "isto\u010dno australsko ljetno vrijeme",
               "AEDT",
               "isto\u010dno australsko vrijeme",
               "EAT",
            };
        final String[] Gilbert_Islands = new String[] {
               "vrijeme Gilbertovih Otoka",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "planinsko standardno vrijeme",
               "MST",
               "planinsko ljetno vrijeme",
               "MDT",
               "planinsko vrijeme",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "vrijeme Marquesasa",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "arapsko standardno vrijeme",
               "AST",
               "arapsko ljetno vrijeme",
               "ADT",
               "arapsko vrijeme",
               "AT",
            };
        final String[] Alaska = new String[] {
               "alja\u0161ko standardno vrijeme",
               "AKST",
               "alja\u0161ko ljetno vrijeme",
               "AKDT",
               "alja\u0161ko vrijeme",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "vladivosto\u010dko standardno vrijeme",
               "VST",
               "vladivosto\u010dko ljetno vrijeme",
               "VST",
               "vladivosto\u010dko vrijeme",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "vrijeme Chamorro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsko standardno vrijeme",
               "IST",
               "Irkutsko ljetno vrijeme",
               "IST",
               "Irkutsko vrijeme",
               "IT",
            };
        final String[] Tokelau = new String[] {
               "vrijeme Tokelau",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "vrijeme Papue Nove Gvineje",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "standardno vrijeme prema gradu Fernando de Noronha",
               "FNST",
               "ljetno vrijeme prema gradu Fernando de Noronha",
               "FNST",
               "vrijeme prema gradu Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsansko standardno vrijeme",
               "CST",
               "Choibalsansko ljetno vrijeme",
               "CST",
               "Choibalsansko vrijeme",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "brazilijsko standardno vrijeme",
               "BST",
               "brazilijsko ljetno vrijeme",
               "BST",
               "brazilijsko vrijeme",
               "BT",
            };
        final String[] China = new String[] {
               "kinesko standardno vrijeme",
               "CST",
               "kinesko ljetno vrijeme",
               "CDT",
               "kinesko vrijeme",
               "CT",
            };
        final String[] India = new String[] {
               "indijsko vrijeme",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "standardno vrijeme Cookovih Otoka",
               "CIST",
               "poluljetno vrijeme Cookovih Otoka",
               "CIHST",
               "vrijeme Cookovih Otoka",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", GMT },
            { "Africa/Windhoek", Africa_Western },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Africa/Juba", Africa_Eastern },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
