/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.ko;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ko extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\uc911\uc559\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\ubaa8\uc2a4\ud06c\ubc14 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\uc2a4\ud06c\ubc14 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\uc2a4\ud06c\ubc14 \uc2dc\uac04",
               "MT",
            };
        final String[] Japan = new String[] {
               "\uc77c\ubcf8 \ud45c\uc900\uc2dc",
               "JST",
               "\uc77c\ubcf8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "JDT",
               "\uc77c\ubcf8 \uc2dc\uac04",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\ud30c\ud0a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ud0a4\uc2a4\ud0c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ud0a4\uc2a4\ud0c4 \uc2dc\uac04",
               "PT",
            };
        final String[] Taipei = new String[] {
               "\ud0c0\uc774\ubca0\uc774 \ud45c\uc900\uc2dc",
               "TST",
               "\ud0c0\uc774\ubca0\uc774 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "TDT",
               "\ud0c0\uc774\ubca0\uc774 \uc2dc\uac04",
               "TT",
            };
        final String[] Hovd = new String[] {
               "\ud638\ube0c\ub4dc \ud45c\uc900\uc2dc",
               "HST",
               "\ud638\ube0c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "HST",
               "\ud638\ube0c\ub4dc \uc2dc\uac04",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\ub9c8\uac00\ub2e8 \ud45c\uc900\uc2dc",
               "MST",
               "\ub9c8\uac00\ub2e8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MST",
               "\ub9c8\uac00\ub2e8 \uc2dc\uac04",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\uc11c\ubd80 \ud45c\uc900\uc2dc",
               "ACWST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ACWDT",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\uc11c\ubd80 \uc2dc\uac04",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\uc911\ubd80\uc720\ub7fd \ud45c\uc900\uc2dc",
               "CEST",
               "\uc911\ubd80\uc720\ub7fd \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CEST",
               "\uc911\ubd80\uc720\ub7fd \uc2dc\uac04",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\uc0ac\ud560\ub9b0 \ud45c\uc900\uc2dc",
               "SST",
               "\uc0ac\ud560\ub9b0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "SST",
               "\uc0ac\ud560\ub9b0 \uc2dc\uac04",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "\ud30c\ub77c\uacfc\uc774 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ub77c\uacfc\uc774 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ub77c\uacfc\uc774 \uc2dc\uac04",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "\ub9d0\ub808\uc774\uc2dc\uc544 \ud45c\uc900\uc2dc",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "\ubbf8 \ub3d9\ubd80 \ud45c\uc900\uc2dc",
               "EST",
               "\ubbf8 \ub3d9\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EDT",
               "\ubbf8 \ub3d9\ubd80 \uc2dc\uac04",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\ub85c\ub4dc \ud558\uc6b0 \ud45c\uc900\uc2dc",
               "LHST",
               "\ub85c\ub4dc \ud558\uc6b0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "LHDT",
               "\ub85c\ub4dc \ud558\uc6b0 \uc2dc\uac04",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\ub274\uc9c8\ub79c\ub4dc \ud45c\uc900\uc2dc",
               "NZST",
               "\ub274\uc9c8\ub79c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "NZDT",
               "\ub274\uc9c8\ub79c\ub4dc \uc2dc\uac04",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\uc601\uad6d\ub839 \uc778\ub3c4\uc591 \uc2dd\ubbfc\uc9c0 \ud45c\uc900\uc2dc",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\uc57c\ucfe0\uce20\ud06c \ud45c\uc900\uc2dc",
               "YST",
               "\uc57c\ucfe0\uce20\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "YST",
               "\uc57c\ucfe0\uce20\ud06c \uc2dc\uac04",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "\ubaa8\ub9ac\uc154\uc2a4 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\ub9ac\uc154\uc2a4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\ub9ac\uc154\uc2a4 \uc2dc\uac04",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "\ub3d9\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Eastern = new String[] {
               "\ub3d9\ubd80\uc720\ub7fd \ud45c\uc900\uc2dc",
               "EEST",
               "\ub3d9\ubd80\uc720\ub7fd \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EEST",
               "\ub3d9\ubd80\uc720\ub7fd \uc2dc\uac04",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\ub274\ud380\ub4e4\ub79c\ub4dc \ud45c\uc900\uc2dc",
               "NST",
               "\ub274\ud380\ub4e4\ub79c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "NDT",
               "\ub274\ud380\ub4e4\ub79c\ub4dc \uc2dc\uac04",
               "NT",
            };
        final String[] Hong_Kong = new String[] {
               "\ud64d\ucf69 \ud45c\uc900\uc2dc",
               "HKST",
               "\ud64d\ucf69 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "HKST",
               "\ud64d\ucf69 \uc2dc\uac04",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc11c\ubd80 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc11c\ubd80 \uc2dc\uac04",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\ub300\uc11c\uc591 \ud45c\uc900\uc2dc",
               "AST",
               "\ubbf8 \ub300\uc11c\uc591 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ADT",
               "\ub300\uc11c\uc591 \uc2dc\uac04",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "\ubcfc\ub9ac\ube44\uc544 \ud45c\uc900\uc2dc",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871 \ud45c\uc900\uc2dc",
               "PMST",
               "\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PMDT",
               "\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871 \uc2dc\uac04",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\uc778\ub3c4\ucc28\uc774\ub098 \uc2dc\uac04",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "\uc608\uce74\ud14c\ub9b0\ubd80\ub974\ud06c \ud45c\uc900\uc2dc",
               "YST",
               "\uc608\uce74\ud14c\ub9b0\ubd80\ub974\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "YST",
               "\uc608\uce74\ud14c\ub9b0\ubd80\ub974\ud06c \uc2dc\uac04",
               "YT",
            };
        final String[] Maldives = new String[] {
               "\ubab0\ub514\ube0c \ud45c\uc900\uc2dc",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Israel = new String[] {
               "\uc774\uc2a4\ub77c\uc5d8 \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\uc2a4\ub77c\uc5d8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "IDT",
               "\uc774\uc2a4\ub77c\uc5d8 \uc2dc\uac04",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\uc778\ub3c4\ub124\uc2dc\uc544 \uc911\ubd80 \uc2dc\uac04",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "\ub0a8\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\uc1fc\uc640 \ud45c\uc900\uc2dc",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Uzbekistan = new String[] {
               "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc2dc\uac04",
               "UT",
            };
        final String[] Omsk = new String[] {
               "\uc634\uc2a4\ud06c \ud45c\uc900\uc2dc",
               "OST",
               "\uc634\uc2a4\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "OST",
               "\uc634\uc2a4\ud06c \uc2dc\uac04",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "\uc138\uc774\uc178 \ud45c\uc900\uc2dc",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "\uc6b0\ub8e8\uacfc\uc774 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\ub8e8\uacfc\uc774 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\ub8e8\uacfc\uc774 \uc2dc\uac04",
               "UT",
            };
        final String[] Nepal = new String[] {
               "\ub124\ud314 \ud45c\uc900\uc2dc",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "\uc6b8\ub780\ubc14\ud1a0\ub974 \ud45c\uc900\uc2dc",
               "UBST",
               "\uc6b8\ub780\ubc14\ud1a0\ub974 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "UBST",
               "\uc6b8\ub780\ubc14\ud1a0\ub974 \uc2dc\uac04",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\ubbf8 \uc911\ubd80 \ud45c\uc900\uc2dc",
               "CST",
               "\ubbf8 \uc911\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\ubbf8 \uc911\ubd80 \uc2dc\uac04",
               "CT",
            };
        final String[] Falkland = new String[] {
               "\ud3ec\ud074\ub79c\ub4dc \ud45c\uc900\uc2dc",
               "FIST",
               "\ud3ec\ud074\ub79c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "FIST",
               "\ud3ec\ud074\ub79c\ub4dc \uc2dc\uac04",
               "FIT",
            };
        final String[] Novosibirsk = new String[] {
               "\ub178\ubcf4\uc2dc\ube44\ub974\uc2a4\ud06c \ud45c\uc900\uc2dc",
               "NST",
               "\ub178\ubcf4\uc2dc\ube44\ub974\uc2a4\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "NST",
               "\ub178\ubcf4\uc2dc\ube44\ub974\uc2a4\ud06c \uc2dc\uac04",
               "NT",
            };
        final String[] Singapore = new String[] {
               "\uc2f1\uac00\ud3ec\ub974 \ud45c\uc900\uc2dc",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "\uc544\uc870\ub808\uc2a4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc870\ub808\uc2a4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc870\ub808\uc2a4 \uc2dc\uac04",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "\ubd80\ud0c4 \ud45c\uc900\uc2dc",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "\uc218\ub9ac\ub0a8 \ud45c\uc900\uc2dc",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Krasnoyarsk = new String[] {
               "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \ud45c\uc900\uc2dc",
               "KST",
               "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "KST",
               "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \uc2dc\uac04",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\uc11c\ubd80 \uce74\uc790\ud750\uc2a4\ud0c4 \uc2dc\uac04",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "\ubbf8\uc580\ub9c8 \ud45c\uc900\uc2dc",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c \ud45c\uc900\uc2dc",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\uc544\ub9c8\uc874 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub9c8\uc874 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub9c8\uc874 \uc2dc\uac04",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\ub3d9\ubd80 \uce74\uc790\ud750\uc2a4\ud0c4 \uc2dc\uac04",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "\ud53c\uc9c0 \ud45c\uc900\uc2dc",
               "FST",
               "\ud53c\uc9c0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "FST",
               "\ud53c\uc9c0 \uc2dc\uac04",
               "FT",
            };
        final String[] Reunion = new String[] {
               "\ub9ac\uc720\ub2c8\uc628 \ud45c\uc900\uc2dc",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "\ucf54\ucf54\uc2a4\uc12c \ud45c\uc900\uc2dc",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "\ucc44\ud140 \ud45c\uc900\uc2dc",
               "CST",
               "\ucc44\ud140 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\ucc44\ud140 \uc2dc\uac04",
               "CT",
            };
        final String[] Vostok = new String[] {
               "\ubcf4\uc2a4\ud1a0\ud06c \ud45c\uc900\uc2dc",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\uc544\ub974\ud5e8\ud2f0\ub098 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc2dc\uac04",
               "AT",
            };
        final String[] Galapagos = new String[] {
               "\uac08\ub77c\ud30c\uace0\uc2a4 \ud45c\uc900\uc2dc",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "\ub9e5\ucffc\ub9ac \ud45c\uc900\uc2dc",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "\ubca0\ub124\uc8fc\uc5d8\ub77c \ud45c\uc900\uc2dc",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\ud558\uc640\uc774 \uc54c\ub958\uc0e8 \ud45c\uc900\uc2dc",
               "HAST",
               "\ud558\uc640\uc774 \uc54c\ub958\uc0e8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "HADT",
               "\ud558\uc640\uc774 \uc54c\ub958\uc0e8 \uc2dc\uac04",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\ubd80 \ud45c\uc900\uc2dc",
               "ACST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ACDT",
               "\uc911\uc559 \uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc2dc\uac04",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "\ubbf8 \ud0dc\ud3c9\uc591 \ud45c\uc900\uc2dc",
               "PST",
               "\ubbf8 \ud0dc\ud3c9\uc591 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PDT",
               "\ubbf8 \ud0dc\ud3c9\uc591 \uc2dc\uac04",
               "PT",
            };
        final String[] Turkmenistan = new String[] {
               "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "TST",
               "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "TST",
               "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \uc2dc\uac04",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "\uc11c\ubd80 \uc720\ub7fd \ud45c\uc900\uc2dc",
               "WEST",
               "\uc11c\ubd80 \uc720\ub7fd \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WEST",
               "\uc11c\ubd80 \uc720\ub7fd \uc2dc\uac04",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\uce74\ubcf4 \ubca0\ub974\ub370 \ud45c\uc900\uc2dc",
               "CVST",
               "\uce74\ubcf4 \ubca0\ub974\ub370 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CVST",
               "\uce74\ubcf4 \ubca0\ub974\ub370 \uc2dc\uac04",
               "CVT",
            };
        final String[] Rothera = new String[] {
               "\ub85c\ub370\ub77c \ud45c\uc900\uc2dc",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Azerbaijan = new String[] {
               "\uc544\uc81c\ub974\ubc14\uc774\uc794 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc81c\ub974\ubc14\uc774\uc794 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc81c\ub974\ubc14\uc774\uc794 \uc2dc\uac04",
               "AT",
            };
        final String[] Mawson = new String[] {
               "\ubaa8\uc2a8 \ud45c\uc900\uc2dc",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "\ub370\uc774\ube44\uc2a4 \ud45c\uc900\uc2dc",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\ucfe0\ubc14 \ud45c\uc900\uc2dc",
               "CST",
               "\ucfe0\ubc14 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\ucfe0\ubc14 \uc2dc\uac04",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\uc11c\uc544\ud504\ub9ac\uce74 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc11c\uc544\ud504\ub9ac\uce74 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc11c\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "\ud544\ub9ac\ud540 \ud45c\uc900\uc2dc",
               "PST",
               "\ud544\ub9ac\ud540 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud544\ub9ac\ud540 \uc2dc\uac04",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\ud504\ub791\uc2a4\ub839 \ub0a8\ucabd\uc2dd\ubbfc\uc9c0 \ud45c\uc900\uc2dc",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "\uc0ac\uc6b0\uc2a4 \uc870\uc9c0\uc544 \ud45c\uc900\uc2dc",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Volgograd = new String[] {
               "\ubcfc\uace0\uadf8\ub77c\ub4dc \ud45c\uc900\uc2dc",
               "VST",
               "\ubcfc\uace0\uadf8\ub77c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "VST",
               "\ubcfc\uace0\uadf8\ub77c\ub4dc \uc2dc\uac04",
               "VT",
            };
        final String[] Brunei = new String[] {
               "\ube0c\ub8e8\ub098\uc774 \ub2e4\ub8e8\uc0b4\ub78c \ud45c\uc900\uc2dc",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "\uc774\ub780 \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\ub780 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "IDT",
               "\uc774\ub780 \uc2dc\uac04",
               "IT",
            };
        final String[] Easter = new String[] {
               "\uc774\uc2a4\ud130\uc12c \ud45c\uc900\uc2dc",
               "EIST",
               "\uc774\uc2a4\ud130\uc12c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EIST",
               "\uc774\uc2a4\ud130\uc12c \uc2dc\uac04",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "\ub4a4\ubabd \ub4a4\ub974\ube4c \ud45c\uc900\uc2dc",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tajikistan = new String[] {
               "\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "\ubc29\uae00\ub77c\ub370\uc2dc \ud45c\uc900\uc2dc",
               "BST",
               "\ubc29\uae00\ub77c\ub370\uc2dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "BST",
               "\ubc29\uae00\ub77c\ub370\uc2dc \uc2dc\uac04",
               "BT",
            };
        final String[] Peru = new String[] {
               "\ud398\ub8e8 \ud45c\uc900\uc2dc",
               "PST",
               "\ud398\ub8e8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud398\ub8e8 \uc2dc\uac04",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "\uadf8\ub9b0\ub780\ub4dc \uc11c\ubd80 \ud45c\uc900\uc2dc",
               "WGST",
               "\uadf8\ub9b0\ub780\ub4dc \uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WGST",
               "\uadf8\ub9b0\ub780\ub4dc \uc11c\ubd80 \uc2dc\uac04",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\uc5d0\ucf70\ub3c4\ub974 \ud45c\uc900\uc2dc",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "\uadf8\ub9b0\ub780\ub4dc \ub3d9\ubd80 \ud45c\uc900\uc2dc",
               "EGST",
               "\uadf8\ub9b0\ub780\ub4dc \ub3d9\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EGST",
               "\uadf8\ub9b0\ub780\ub4dc \ub3d9\ubd80 \uc2dc\uac04",
               "EGT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\uc778\ub3c4\ub124\uc2dc\uc544 \ub3d9\ubd80 \uc2dc\uac04",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "\ud55c\uad6d \ud45c\uc900\uc2dc",
               "KST",
               "\ud55c\uad6d \ud558\uacc4 \ud45c\uc900\uc2dc",
               "KDT",
               "\ud55c\uad6d \uc2dc\uac04",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc11c\ubd80 \ud45c\uc900\uc2dc",
               "AWST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AWDT",
               "\uc11c\ubd80 \uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc2dc\uac04",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "\uc778\ub3c4\ub124\uc2dc\uc544 \uc11c\ubd80 \uc2dc\uac04",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \ub3d9\ubd80 \ud45c\uc900\uc2dc",
               "AEST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \ub3d9\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AEDT",
               "\ub3d9\ubd80 \uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc2dc\uac04",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098 \ud45c\uc900\uc2dc",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "\ucf5c\ub86c\ube44\uc544 \ud45c\uc900\uc2dc",
               "CST",
               "\ucf5c\ub86c\ube44\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CST",
               "\ucf5c\ub86c\ube44\uc544 \uc2dc\uac04",
               "CT",
            };
        final String[] Chile = new String[] {
               "\uce60\ub808 \ud45c\uc900\uc2dc",
               "CST",
               "\uce60\ub808 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CST",
               "\uce60\ub808 \uc2dc\uac04",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "\ubbf8 \uc0b0\uc545 \ud45c\uc900\uc2dc",
               "MST",
               "\ubbf8 \uc0b0\uc9c0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MDT",
               "\ubbf8 \uc0b0\uc9c0 \uc2dc\uac04",
               "MT",
            };
        final String[] Arabian = new String[] {
               "\uc544\ub77c\ube44\uc544 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub77c\ube44\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ADT",
               "\uc544\ub77c\ube44\uc544 \uc2dc\uac04",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\uc54c\ub798\uc2a4\uce74 \ud45c\uc900\uc2dc",
               "AKST",
               "\uc54c\ub798\uc2a4\uce74 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AKDT",
               "\uc54c\ub798\uc2a4\uce74 \uc2dc\uac04",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a0\ud06c \ud45c\uc900\uc2dc",
               "VST",
               "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a0\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "VST",
               "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a0\ud06c \uc2dc\uac04",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "\ucc28\ubaa8\ub85c \uc2dc\uac04",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "\uc774\ub974\ucfe0\uce20\ud06c \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\ub974\ucfe0\uce20\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\ub974\ucfe0\uce20\ud06c \uc2dc\uac04",
               "IT",
            };
        final String[] Georgia = new String[] {
               "\uadf8\ub8e8\uc9c0\uc544 \ud45c\uc900\uc2dc",
               "GST",
               "\uadf8\ub8e8\uc9c0\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "GST",
               "\uadf8\ub8e8\uc9c0\uc544 \uc2dc\uac04",
               "GT",
            };
        final String[] Noronha = new String[] {
               "\ud398\ub974\ub09c\ub3c4 \ub370 \ub178\ub85c\ub0d0 \ud45c\uc900\uc2dc",
               "FNST",
               "\ud398\ub974\ub09c\ub3c4 \ub370 \ub178\ub85c\ub0d0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "FNST",
               "\ud398\ub974\ub09c\ub3c4 \ub370 \ub178\ub85c\ub0d0 \uc2dc\uac04",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\ucd08\uc774\ubc1c\uc0b0 \ud45c\uc900\uc2dc",
               "CST",
               "\ucd08\uc774\ubc1c\uc0b0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CST",
               "\ucd08\uc774\ubc1c\uc0b0 \uc2dc\uac04",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\ube0c\ub77c\uc9c8\ub9ac\uc544 \ud45c\uc900\uc2dc",
               "BST",
               "\ube0c\ub77c\uc9c8\ub9ac\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "BST",
               "\ube0c\ub77c\uc9c8\ub9ac\uc544 \uc2dc\uac04",
               "BT",
            };
        final String[] China = new String[] {
               "\uc911\uad6d \ud45c\uc900\uc2dc",
               "CST",
               "\uc911\uad6d \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\uc911\uad6d \uc2dc\uac04",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\uc544\ub974\uba54\ub2c8\uc544 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\uba54\ub2c8\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\uba54\ub2c8\uc544 \uc2dc\uac04",
               "AT",
            };
        final String[] India = new String[] {
               "\uc778\ub3c4 \ud45c\uc900\uc2dc",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\ucfe1\uc81c\ub3c4 \ud45c\uc900\uc2dc",
               "CIST",
               "\ucfe1\uc81c\ub3c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CIHST",
               "\ucfe1\uc81c\ub3c4 \uc2dc\uac04",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Indian/Cocos", Cocos },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
